#!/usr/bin/env bash
set -euo pipefail

# Always run from this script's folder
cd "$(dirname "$0")/src"

# Find python
if command -v python3 >/dev/null 2>&1; then
  PY=python3
elif command -v python >/dev/null 2>&1; then
  PY=python
else
  osascript -e 'display alert "Python 3 not found. Install from python.org or Homebrew (brew install python)."'
  exit 1
fi

# Create venv if missing
if [ ! -x ".venv/bin/python" ]; then
  "$PY" -m venv .venv
fi

PYEXE=".venv/bin/python"

# Upgrade pip and install deps
"$PYEXE" -m pip install --upgrade pip >/dev/null
if [ -f requirements.txt ]; then
  "$PYEXE" -m pip install -r requirements.txt
else
  "$PYEXE" -m pip install flask requests python-dotenv pandas
fi

# Run the app (browser opens from run_server.py)
exec "$PYEXE" ./run_server.py